<?php
/**
 * Account Lock
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('accountlock_title',true).'</span></div>';

try {
	
	$AccountLock = new \Plugin\AccountLock\AccountLock();
	$AccountLock->setUser($_SESSION['username']);
	
	if(check_value($_GET['email'])) {
		message('success', lang('accountlock_success_2',true));
	}
	
	echo '<div class="col-xs-8 col-xs-offset-2 text-center" style="margin-top:30px;">';
		echo '<h3>'.lang('accountlock_txt_1',true).'</h3>';
		
		if($AccountLock->isLocked()) {
			echo '<span style="color:red;font-size:18px;">'.lang('accountlock_txt_2',true).'</span>';
			echo '<br /><br /><br /><br />';
			echo '<a href="'.__BASE_URL__.'accountlock/unlock/email/1" class="btn btn-lg btn-success">'.lang('accountlock_txt_4',true).'</a>';
		} else {
			echo '<span style="color:green;font-size:18px;">'.lang('accountlock_txt_3',true).'</span>';
			echo '<br /><br /><br /><br />';
			echo '<a href="'.__BASE_URL__.'accountlock/lock" class="btn btn-lg btn-danger" style="color:#fff;">'.lang('accountlock_txt_5',true).'</a>';
		}
		
	echo '</div>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}